<?php

abstract class SAXParser {

   private $parser;
   protected $tagName = "";

   abstract public function startElement($parser, $name, $attributes);
   abstract public function endElement($parser, $name);
   abstract public function characterData($parser, $data);
   
   public function parse($xml) {
      xml_parse($this->parser, $xml);
   }
   public function __construct($xml) {
      $this->parser = xml_parser_create();
      xml_set_object($this->parser, $this);
      xml_parser_set_option($this->parser, XML_OPTION_CASE_FOLDING, 0);
      xml_set_element_handler($this->parser, "startElement", "endElement");
      xml_set_character_data_handler($this->parser, "characterData");
   }
}
class PetParser extends SAXParser {
   public $petName;
   public $petId;
   public function startElement($parser, $name, $attributes) {
      if ($name == "Nazwa") {
         $this->tagName = $name;
         $this->petId = $attributes['id'];
      }
   }
   public function characterData($parser, $data) {
      if ($this->tagName == "Nazwa") {
         $this->petName = $data;
      }
   }
   Public function endElement($parser, $name) {
      $this->tagName = "";
   }
}

?>